<?php
	class MyLanguage {	
		public $language;
		public $fallback = 'farsi';
		
		function language_exists($language) {
			$language = preg_replace("#[^a-z0-9\-_]#i", "", $language);
			if(file_exists("language/".$language.".php")) {
				return true;
			} else {
				return false;
			}
		}
		
		function set_language($language="fa") {
			$language = preg_replace("#[^a-z0-9\-_]#i", "", $language);

			// Default language is Farsi.
			if($language == "") {
				$language = "fa";
			}

			// Check if the language exists.
			if(!$this->language_exists($language)) {
				die("Language $language ($language) is not installed");
			}

			$this->language = $language;
			require "language/".$language.".php";
		}
		
		function load() {
		// Assign language variables.
			$lfile = "language/".$this->language.".php";

			if(file_exists($lfile)) {
				require_once $lfile;
			} elseif(file_exists("language/".$this->fallback.".php")) {
				require_once "language/".$this->fallback.".php";
			} else {
				die("$lfile does not exist");
			}

			// We must unite and protect our language variables!
			$lang_keys_ignore = array('language', 'path', 'settings');

			if(isset($l) && is_array($l)) {
				foreach($l as $key => $val) {
					if((empty($this->$key) || $this->$key != $val) && !in_array($key, $lang_keys_ignore)) {
						$this->$key = $val;
					}
				}
			}
		}
		
		function sprintf($string) {
			$arg_list = func_get_args();
			$num_args = count($arg_list);
			for($i = 1; $i < $num_args; $i++) {
				$string = str_replace('{'.$i.'}', $arg_list[$i], $string);
			}
			return $string;
		}
		
		function parse($contents) {
			$contents = preg_replace_callback("#<lang:([a-zA-Z0-9_]+)>#", array($this, 'parse_replace'), $contents);
			return $contents;
		}
		
		function parse_replace($matches) {
			return $this->{$matches[1]};
		}
	}
?>